$TITLE: JGEA1 basic model

$ONTEXT
This model is a closed economy version of the classic
Heckscher-Ohlin model: two goods and two factors, one consumer

Consumer endowed with labor and capital, which are used to produce X and Y
X and Y are treated as though they combine to produce utility U
Consumer buys U with the income from labor and capital

The following table shows the model calibration
   Row sum = zero indicates market clearing
   Column sum = zero indicates zero profits for X and Y or income balance

               Production Sectors     Consumers
   Markets   |    X       Y       U       I
   ------------------------------------------------------
        PX   |  100            -100  |
        PY   |          100    -100  |
        W    |  -25     -75          |   100
        R    |  -75     -25          |   100
        PU   |                  200  |  -200
   ------------------------------------------------------
$OFFTEXT


PARAMETERS
 LBAR     labor endowment
 KBAR     capital endowment;

LBAR = 100;
KBAR = 100;

NONNEGATIVE VARIABLES

 U       activity level for utility or welfare
 X       activity level for X production
 Y       activity level for Y production

 PX      price of good X
 PY      price of good Y
 W       price of labor
 R       price of capital
 PU      price of welfare (expenditure function)

 I       income of the representative consumer;

EQUATIONS

 PRF_U   zero profit for welfare
 PRF_X   zero profit for sector X
 PRF_Y   zero profit for sector Y

 MKT_X   supply-demand balance for commodity X
 MKT_Y   supply-demand balance for commodity Y
 MKT_L   supply-demand balance for primary factor L
 MKT_K   supply-demand balance for primary factor K
 MKT_U   supply-demand balance for welfare

 INC_I   income balance;

*       List equation names followed by double dot ..
*       then write out weak inequalities in greater than or equal to format

*       Zero profit inequalities

PRF_X..      W**0.25 * R**0.75 =G= PX;

PRF_Y..      W**0.75 * R**0.25 =G= PY;

PRF_U..      PX**0.5 * PY**0.5 =G= PU;

*       Market clearance inequalities

MKT_L..      LBAR =G= 0.25*(R/W)**0.75*X  +
                      0.75*(R/W)**0.25*Y;

MKT_K..      KBAR =G= 0.75*(W/R)**0.25*X +
                      0.25*(W/R)**0.75*Y;

MKT_X..      X    =G= 0.5*U*PU/PX;

MKT_Y..      Y    =G= 0.5*U*PU/PY;

MKT_U..      U    =G= I/PU;

*       Income balance equation

INC_I..      I =E= LBAR*W + KBAR*R;


*       Declare a model name, list equation names followed by dot and name
*       of complementary variable

MODEL CLOSED /PRF_U.U, PRF_X.X, PRF_Y.Y,
              MKT_X.PX, MKT_Y.PY, MKT_L.W, MKT_K.R, MKT_U.PU,
              INC_I.I /;

*       Chose a numeraire: price of U fixed (.FX) at 1

PU.FX = 1;

*       Set initial values of variables (.L notation after variable)

X.L=100; Y.L=100; U.L = 100; I.L=200;
PX.L=1; PY.L=1; R.L=1; W.L=1; PU.L = 1;


SOLVE CLOSED USING MCP;

*       Counterfactual: double the endowment of labor

LBAR = 200;
SOLVE CLOSED USING MCP;

* Counterfactual: double the endowment of capital
LBAR = 100;
KBAR = 200;
SOLVE CLOSED USING MCP;

* Counterfactual: double the endowment of labor and capital
LBAR = 200;
KBAR = 200;
SOLVE CLOSED USING MCP;


*       Convert the model to a small open economy
*       Fix commodity prices and drop market clearing equations
*       for X and Y and for income balance.  Free up the wage rate.

MODEL SOE /PRF_U.U, PRF_X.X, PRF_Y.Y,
           MKT_L.W, MKT_K.R, MKT_U.PU, INC_I.I/;

*       Fix X and Y prices, unfix PU, set L back to benchmark = 100

PX.FX = 1; PY.FX = 1;
PU.UP = +INF; PU.LO = 0;
LBAR = 100; KBAR = 100;

SOLVE SOE USING MCP;

*        demonstrate the Rybsczynski theorem: double labor supply

LBAR = 200;
SOLVE SOE USING MCP;

*        demonstrate the Stolper-Samuelson theorem: increase px to 1.5

LBAR = 100;
PX.FX = 1.5;
SOLVE SOE USING MCP;

*        show a corner solution - economy specializes in X: px = 2

PX.FX = 2.0;
SOLVE SOE USING MCP;
